const { createServer } = require("http"); 
const { readFileSync } = require("fs");
const express = require("express");
const bodyParser = require("body-parser");
const morganBody = require("morgan-body");
const morgan = require("morgan");
const app = express();
const fs = require("fs");
const cors = require("cors");
app.use(express.json());
require("dotenv").config();
app.use(cors());

app.use(function (req, res, next) {
  res.header("Access-Control-Allow-Origin", "*");
  res.setHeader(
    "Access-Control-Allow-Methods",
    "GET, POST, OPTIONS, PUT, PATCH, DELETE"
  );
  res.header(
    "Access-Control-Allow-Headers",
    "Origin, X-Requested-With, Content-Type, Accept"
  );
  next();
});

app.use(morgan("dev"));

morganBody(app, {
  prettify: true,
  logReqUserAgent: true,
  logReqDateTime: true,
});
const notificationRoute = require("./routes/notificationRoutes");
app.use(process.env.API_URL, notificationRoute);

const httpsServer = createServer(
//   {
//     key: readFileSync(
//       "/home/dashboardanrear/ssl/keys/cf600_ac3c9_33b19bf53cfa537de5b55543fd79922c.key"
//     ),
//     cert: readFileSync(
//       "/home/dashboardanrear/ssl/certs/dashboard_anrear_com_cf600_ac3c9_1715888701_f7ca48ad7fad02d1b08e52dc36c2450c.crt"
//     ),
//     ca: readFileSync("/home/dashboardanrear/ssl/certs/ca.crt"),
//   },
  app
);

httpsServer.listen(5001, () => {
  console.log("Server up on Port ", 5001);
});
