const admin = require("firebase-admin");
var serviceAccount = require("./anrear-5b874-firebase-adminsdk-kteix-e231563e13.json");

admin.initializeApp({
  credential: admin.credential.cert(serviceAccount),
});

const { push_notifications } = require("./../config/push_notification");

const SendNotification = async (req, res) => {
  

  const { title, body, TokenList } = req.body;

  try {
    TokenList.forEach(async (item) => {
      const notification_obj = {
        user_device_token: item.user_device_token,
        title: title,
        body: body,
      };

      await push_notifications(notification_obj);
    });
    return res.status(200).send({
      status: 1,
      message: "You have send notification Successfully.",
    });
  } catch (e) {
    return res.status(400).send(e);
  }
};
const deleteUser = async (req, res) => {
  try {
    const { id } = req.params;
    console.log(id);
    admin
      .auth()
      .deleteUser(id)
      .then(function () {
        console.log("Successfully deleted user");
      })
      .catch(function (error) {
        console.log("Error deleting user:", error);
      });
    res.send({ message: "user deleted", status: true });
  } catch (e) {
    res.send({ message: e.message, status: false });
  }
};

module.exports = {
  SendNotification,
  deleteUser,
};
